document.addEventListener('DOMContentLoaded', () => {
    const checkoutForm = document.getElementById('checkoutForm');
    const summarySubtotalSpan = document.getElementById('summarySubtotal');
    const summaryShippingFeeSpan = document.getElementById('summaryShippingFee');
    const summaryDiscountSpan = document.getElementById('summaryDiscount');
    const summaryTotalSpan = document.getElementById('summaryTotal');
    const summaryVoucherCodeSpan = document.getElementById('summaryVoucherCode');
    const cartItemCountSpan = document.getElementById('cartItemCount'); // For header count
    const toastContainer = document.getElementById('toastContainer');

    let orderSummary = JSON.parse(sessionStorage.getItem('orderSummary')) || {
        subtotal: 0,
        shippingFee: 0,
        discount: 0,
        total: 0,
        appliedVoucherCode: null
    };

    // Hàm hiển thị thông báo toast
    function showToast(message, duration = 3000) {
        const toast = document.createElement('div');
        toast.classList.add('toast-message');
        toast.textContent = message;

        toastContainer.appendChild(toast);

        setTimeout(() => {
            toast.remove();
        }, duration + 500);
    }

    // Hàm lấy giỏ hàng từ Local Storage
    function getCartFromLocalStorage() {
        const cartString = localStorage.getItem('cart');
        return cartString ? JSON.parse(cartString) : [];
    }

    // Hàm lưu giỏ hàng vào Local Storage
    function saveCartToLocalStorage(cart) {
        localStorage.setItem('cart', JSON.stringify(cart));
    }

    // Cập nhật số lượng sản phẩm trên icon giỏ hàng
    function updateCartItemCount() {
        const cart = getCartFromLocalStorage();
        const totalItems = cart.reduce((sum, item) => sum + item.quantity, 0);
        cartItemCountSpan.textContent = totalItems;
    }

    // Hiển thị tóm tắt đơn hàng
    function displayOrderSummary() {
        summaryTotalSpan.textContent = 'Phí Giao Hàng';
        summaryShippingFeeSpan.textContent = orderSummary.shippingFee.toLocaleString('vi-VN') + ' VNĐ';
    }


    // Xử lý khi submit form
    checkoutForm.addEventListener('submit', (e) => {
        e.preventDefault(); // Ngăn chặn form submit mặc định

        const cart = getCartFromLocalStorage();
        if (cart.length === 0) {
            showToast('Giỏ hàng trống. Vui lòng thêm sản phẩm trước khi đặt hàng.');
            setTimeout(() => {
                window.location.href = 'index.html'; // Chuyển về trang chủ
            }, 1500);
            return;
        }

        const fullName = document.getElementById('fullName').value.trim();
        const phone = document.getElementById('phone').value.trim();
        const email = document.getElementById('email').value.trim();
        const address = document.getElementById('address').value.trim();
        const notes = document.getElementById('notes').value.trim();
        const paymentMethod = document.querySelector('input[name="paymentMethod"]:checked').value;

        if (!fullName || !phone || !address) {
            showToast('Vui lòng điền đầy đủ thông tin bắt buộc (Họ và tên, Số điện thoại, Địa chỉ).');
            return;
        }

        // Tạo đối tượng đơn hàng
        const order = {
            id: 'ORD' + Date.now(), // ID đơn hàng đơn giản
            date: new Date().toLocaleString('vi-VN'),
            customerInfo: { fullName, phone, email, address, notes },
            items: cart,
            summary: orderSummary,
            paymentMethod: paymentMethod,
            status: 'Pending'
        };

        // Lưu đơn hàng vào localStorage (đây chỉ là ví dụ, thực tế sẽ gửi lên server)
        let orders = JSON.parse(localStorage.getItem('orders') || '[]');
        orders.push(order);
        localStorage.setItem('orders', JSON.stringify(orders));

        // Xóa giỏ hàng và dữ liệu tổng kết sau khi đặt hàng thành công
        saveCartToLocalStorage([]);
        sessionStorage.removeItem('orderSummary');

        showToast('Đơn hàng của bạn đã được đặt thành công! Cảm ơn bạn đã mua sắm.', 5000);

        // Chuyển hướng về trang chủ hoặc trang xác nhận đơn hàng
        setTimeout(() => {
            window.location.href = 'index.html';
        }, 3000); // Chờ toast hiển thị rồi chuyển hướng
    });

    // Khởi tạo
    if (cart.length === 0 && !orderSummary.total) {
        showToast('Giỏ hàng trống. Vui lòng thêm sản phẩm trước khi thanh toán.', 2000);
        setTimeout(() => {
            window.location.href = 'index.html';
        }, 2500);
        return;
    }

    displayOrderSummary();
    updateCartItemCount(); // Cập nhật số lượng giỏ hàng trên header
});