document.addEventListener('DOMContentLoaded', () => {
    let cart = [];
    const vouchers = {
        'SALE10': 0.10, // Giảm 10%
        'SALE20': 0.20, // Giảm 20%
        'SALE30': 0.30, // Giảm 30%
        'SALE40': 0.40, // Giảm 40%
        'SALE50': 0.50, // Giảm 50%
        'SALE60': 0.60, // Giảm 60%
        'SALE70': 0.70, // Giảm 70%
        'SALE80': 0.80, // Giảm 80%
        'SALE90': 0.90, // Giảm 90%
        'FREESHIP': 'freeship',
        'CARDSALESSJ': 0.97 // Giảm 90%

    };
    let appliedVoucher = null;
    const shippingFee = 50; // Phí vận chuyển mặc định (ví dụ: 50 THB) - ĐÃ ĐIỀU CHỈNH

    const cartItemsDiv = document.getElementById('cartItems');
    const totalAmountSpan = document.getElementById('totalAmount');
    const voucherInput = document.getElementById('voucherInput');
    const applyVoucherBtn = document.getElementById('applyVoucherBtn');
    const checkoutBtn = document.getElementById('checkoutBtn');

    // Hàm lấy giỏ hàng từ Local Storage
    function getCartFromLocalStorage() {
        const cartString = localStorage.getItem('cart');
        return cartString ? JSON.parse(cartString) : [];
    }

    // Hàm lưu giỏ hàng vào Local Storage
    function saveCartToLocalStorage(cart) {
        localStorage.setItem('cart', JSON.stringify(cart));
    }

    // Hàm hiển thị giỏ hàng
    function displayCart() {
        cart = getCartFromLocalStorage(); // Lấy giỏ hàng mới nhất
        cartItemsDiv.innerHTML = ''; // Xóa nội dung cũ

        if (cart.length === 0) {
            cartItemsDiv.innerHTML = '<p>Giỏ hàng trống.</p>';
        } else {
            cart.forEach(item => {
                const cartItem = document.createElement('div');
                cartItem.classList.add('cart-item');
                // Hiển thị cả ảnh sản phẩm trong giỏ hàng
                cartItem.innerHTML = `
                    <img src="${item.image}" alt="${item.name}" class="cart-item-image">
                    <div class="cart-item-details">
                        <span class="item-name">${item.name}</span>
                        <span class="item-options">${item.color !== 'No Color' ? item.color : ''}${item.color !== 'No Color' && item.size !== 'Freesize' ? ' / ' : ''}${item.size !== 'Freesize' ? item.size : ''}</span>
                    </div>
                    <div class="cart-item-quantity-control">
                        <button data-id="${item.uniqueId}" data-action="decrease">-</button>
                        <input type="number" value="${item.quantity}" min="1" data-id="${item.uniqueId}">
                        <button data-id="${item.uniqueId}" data-action="increase">+</button>
                    </div>
                    <span class="cart-item-price">${(item.price * item.quantity).toLocaleString('th-TH', { style: 'currency', currency: 'THB' })}</span>
                    <div class="cart-item-remove">
                        <button data-id="${item.uniqueId}">Xóa</button>
                    </div>
                `;
                cartItemsDiv.appendChild(cartItem);
            });
            addCartItemEventListeners(); // Gắn lại sự kiện sau khi render lại
        }
        calculateTotal();
    }

    // Hàm tính toán tổng tiền
    function calculateTotal() {
        let subtotal = cart.reduce((sum, item) => sum + (item.price * item.quantity), 0);
        let currentShippingFee = shippingFee;
        let discountAmount = 0;

        if (appliedVoucher) {
            if (typeof appliedVoucher === 'number') { // Voucher giảm giá phần trăm
                discountAmount = subtotal * appliedVoucher;
                subtotal -= discountAmount;
            } else if (appliedVoucher === 'freeship') { // Voucher freeship
                currentShippingFee = 0; // Miễn phí vận chuyển
            }
        }

        let total = subtotal + currentShippingFee;

        // Cập nhật hiển thị tổng tiền với định dạng THB
        totalAmountSpan.textContent = total.toLocaleString('th-TH', { style: 'currency', currency: 'THB' });

        // Cập nhật các dòng tóm tắt khác (Subtotal, Shipping, Discount)
        document.getElementById('subtotalAmount').textContent = subtotal.toLocaleString('th-TH', { style: 'currency', currency: 'THB' });
        document.getElementById('shippingFeeDisplay').textContent = currentShippingFee.toLocaleString('th-TH', { style: 'currency', currency: 'THB' });
        document.getElementById('discountAmountDisplay').textContent = discountAmount.toLocaleString('th-TH', { style: 'currency', currency: 'THB' });
    }

    // Hàm gắn sự kiện cho các nút tăng/giảm số lượng và xóa sản phẩm
    function addCartItemEventListeners() {
        document.querySelectorAll('.cart-item-quantity-control button').forEach(button => {
            button.addEventListener('click', (e) => {
                const uniqueId = e.target.dataset.id;
                const action = e.target.dataset.action;
                updateQuantity(uniqueId, action);
            });
        });

        document.querySelectorAll('.cart-item-quantity-control input').forEach(input => {
            input.addEventListener('change', (e) => {
                const uniqueId = e.target.dataset.id;
                const newQuantity = parseInt(e.target.value);
                if (!isNaN(newQuantity) && newQuantity >= 1) {
                    updateQuantity(uniqueId, null, newQuantity);
                } else {
                    displayCart(); // Revert if invalid input
                }
            });
        });

        document.querySelectorAll('.cart-item-remove button').forEach(button => {
            button.addEventListener('click', (e) => {
                const uniqueId = e.target.dataset.id;
                removeFromCart(uniqueId);
            });
        });
    }

    // Hàm cập nhật số lượng sản phẩm trong giỏ hàng
    function updateQuantity(uniqueId, action, newQuantity = null) {
        let updatedCart = cart.map(item => {
            if (item.uniqueId === uniqueId) {
                if (newQuantity !== null) {
                    item.quantity = newQuantity;
                } else if (action === 'increase') {
                    item.quantity++;
                } else if (action === 'decrease') {
                    item.quantity--;
                }
            }
            return item;
        }).filter(item => item.quantity > 0); // Xóa sản phẩm nếu số lượng về 0

        saveCartToLocalStorage(updatedCart);
        displayCart(); // Cập nhật lại giao diện
    }

    // Hàm xóa sản phẩm khỏi giỏ hàng
    function removeFromCart(uniqueId) {
        if (confirm('Bạn có chắc muốn xóa sản phẩm này khỏi giỏ hàng không?')) {
            let updatedCart = cart.filter(item => item.uniqueId !== uniqueId);
            saveCartToLocalStorage(updatedCart);
            displayCart();
        }
    }


    // Sự kiện áp dụng voucher
    applyVoucherBtn.addEventListener('click', () => {
        const voucherCode = voucherInput.value.trim().toUpperCase();
        if (vouchers[voucherCode]) {
            appliedVoucher = vouchers[voucherCode];
            let message = `Mã giảm giá "${voucherCode}" đã được áp dụng!`;
            if (appliedVoucher === 'freeship') {
                message += " Phí vận chuyển sẽ được miễn phí.";
            } else {
                message += ` Bạn được giảm ${appliedVoucher * 100}% tổng giá trị đơn hàng.`;
            }
            alert(message);
            calculateTotal();
        } else {
            alert('Mã giảm giá không hợp lệ hoặc đã hết hạn.');
            appliedVoucher = null; // Xóa voucher đã áp dụng nếu không hợp lệ
            calculateTotal(); // Tính toán lại tổng tiền
        }
    });

    // Sự kiện thanh toán
    checkoutBtn.addEventListener('click', () => {
        if (cart.length === 0) {
            alert('Giỏ hàng của bạn đang trống. Vui lòng thêm sản phẩm vào giỏ hàng trước khi thanh toán.');
            return;
        }

        // Lấy giá trị tổng tiền từ span và loại bỏ định dạng tiền tệ để parse số
        const currentTotalText = totalAmountSpan.textContent;
        // Strip out non-numeric characters except for the decimal point for THB
        // For THB, the symbol '฿' is typically prefix, and decimal separator is '.'
        // Example: ฿1,234.50
        const numericTotalString = currentTotalText.replace(/[^0-9.]/g, '');
        const currentTotal = parseFloat(numericTotalString);

        const confirmPayment = confirm(`Bạn có muốn thanh toán trước số tiền **${currentTotal.toLocaleString('th-TH', { style: 'currency', currency: 'THB' })}** không?`); // Hiển thị THB

        if (confirmPayment) {
            alert('Thanh toán thành công! Cảm ơn bạn đã mua sắm tại cửa hàng của chúng tôi.');

            // Xóa giỏ hàng và voucher sau khi thanh toán
            cart = [];
            saveCartToLocalStorage(cart); // Cập nhật Local Storage
            appliedVoucher = null;
            voucherInput.value = '';
            displayCart(); // Cập nhật lại giao diện giỏ hàng
        } else {
            alert('Thanh toán đã bị hủy.');
        }
    });

    // Khởi tạo hiển thị khi tải trang giỏ hàng
    displayCart();
});